<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>IOT Device Command Dashboard</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            padding-top: 20px;
        }
        .btn-custom {
            width: 150px;
        }
        .btn-group {
            margin-bottom: 20px;
        }
        #response {
            margin-top: 20px;
            padding: 10px;
            border: 1px solid #dee2e6;
            border-radius: 4px;
            background-color: #ffffff;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="text-center mb-4">IOT Device Command Dashboard</h1>
        <div class="text-center">
            <div class="btn-group" role="group" aria-label="Light Control">
                <button type="button" class="btn btn-primary btn-custom" onclick="sendMessage('LIGHT_OFF')">Light Off</button>
                <button type="button" class="btn btn-success btn-custom" onclick="sendMessage('LIGHT_ON')">Light On</button>
            </div>
            <div class="btn-group" role="group" aria-label="Fan Control">
                <button type="button" class="btn btn-primary btn-custom" onclick="sendMessage('FAN_OFF')">Fan Off</button>
                <button type="button" class="btn btn-success btn-custom" onclick="sendMessage('FAN_ON')">Fan On</button>
            </div>
            <div class="btn-group" role="group" aria-label="Meter Control">
                <button type="button" class="btn btn-primary btn-custom" onclick="sendMessage('MET_OFF')">Meter Off</button>
                <button type="button" class="btn btn-success btn-custom" onclick="sendMessage('MET_ON')">Meter On</button>
            </div>
        </div>
        <div id="response" class="text-center"></div>
    </div>

    <script>
        const socket = new WebSocket('ws://192.168.1.116:8080');

        socket.onopen = () => {
            console.log('Connected to WebSocket server');
        };

        socket.onmessage = (event) => {
            const message = event.data.trim();
            console.log(message);
            const responseDiv = document.getElementById('response');
            responseDiv.textContent = '[' + new Date().toLocaleTimeString() + '] Received: ' + message;
        };

        socket.onerror = (error) => {
            console.error('WebSocket error:', error);
        };

        function sendMessage(command = null) {
            if (command) {
                socket.send(command); // Sends message from client to server
            } else {
                // const input = document.getElementById('messageInput');
                // const message = input.value;
                socket.send(message); // Sends message from client to server
                // input.value = ''; // Clear the input field
            }
        }
    </script>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
